      SUBROUTINE ABSMO_NUVEL(PSIT,T0,X0,Y0,Z0,T,X,Y,Z)
C
C   ABSMO_NUVEL takes a site specified by its initial coordinates
C   X0,Y0,Z0 at time T0, and computes its updated positions X,Y,Z
C   at time T, based on the geological "absolute".
C
C   Original author: J.B. Minster, Science Horizons.
C   DFA: Revised by Don Argus, Northwestern University
C   DFA: uses absolute model NNR-NUVEL1
C
C   Transcribed from USNO Circular 167 "Project Merit Standards"
C   by Tony Mallama with slight modification to the documentation
C   and code.
C
C   Times are given in years, e.g. 1988.0 for Jan 1, 1988.
C
C   PSIT is the four character abbreviation for the plate name,
C   if PSIT is not recognized then the new positions are returned
C   as zero.
C
      IMPLICIT NONE
      CHARACTER*4        PSIT,PNM(16)
      REAL*8             OMX(16),OMY(16),OMZ(16)
      REAL*8             X0,Y0,Z0
      REAL*8             X,Y,Z,T,T0
      INTEGER*2          IPSIT,I
C
C   DFA: NNR-NUVEL1A
C
      DATA    (PNM(I),     OMX(I),     OMY(I),     OMZ(I),
     &         I =  1,16)
     &        /'PCFC',    -0.001510,   0.004840,  -0.009970,
     &         'AFRC',     0.000891,  -0.003099,   0.003922,
     &         'ANTA',    -0.000821,  -0.001701,   0.003706,
     &         'ARAB',     0.006685,  -0.000521,   0.006760,
     &         'AUST',     0.007839,   0.005124,   0.006282,
     &         'CARB',    -0.000178,  -0.003385,   0.001581,
     &         'COCO',    -0.010425,  -0.021605,   0.010925,
     &         'EURA',    -0.000981,  -0.002395,   0.003153,
     &         'INDI',     0.006670,   0.000040,   0.006790,
     &         'NAZC',    -0.001532,  -0.008577,   0.009609,
     &         'NOAM',     0.000258,  -0.003599,  -0.000153,
     &         'SOAM',    -0.001038,  -0.001515,  -0.000870,
     &         'JUFU',     0.005200,   0.008610,  -0.005820,
     &         'PHIL',     0.010090,  -0.007160,  -0.009670,
     &         'RIVR',    -0.009390,  -0.030960,  -0.012050,
     &         'SCOT',    -0.000410,  -0.002660,  -0.001270/
C
C
C   Initialize things properly
C
      IPSIT = -1
      X = 0.0D0
      Y = 0.0D0
      Z = 0.0D0
C
C   Look up the plate in the list.
C
      DO 20 I = 1,16
   20 IF (PSIT .EQ. PNM(I)) IPSIT = I
C
C   If plate name is not recognized return the new plate position
C   as zero.
C
      IF (IPSIT .EQ. -1) RETURN
C
C   Compute the new coordinates
C
      X = X0 + (OMY(IPSIT)*Z0 - OMZ(IPSIT)*Y0) * (T-T0)/1.0D+6
      Y = Y0 + (OMZ(IPSIT)*X0 - OMX(IPSIT)*Z0) * (T-T0)/1.0D+6
      Z = Z0 + (OMX(IPSIT)*Y0 - OMY(IPSIT)*X0) * (T-T0)/1.0D+6
C
C   Finish up
C
      RETURN
      END
