
C    SUBROUTINE ARG(IYEAR,DAY,ANGLE)
C
C  COMPUTES THE ANGULAR ARGUMENT WHICH DEPENDS ON TIME FOR 11
C  TIDAL ARGUMENT CALCULATIONS
C
C
C    ORDER OF THE 11 ANGULAR QUANTITIES IN VECTOR ANGLE
C
C  01-M2
C  02-S2
C  03-N2
C  04-K2
C  05-K1
C  06-O1
C  07-P1
C  08-Q1
C  09-Mf
C  10-Mm
C  11-Ssa
C
C  TAKEN FROM 'TABLE 1 CONSTANTS OF MAJOR TIDAL MODES'
C       WHICH DR. SCHWIDERSKI SENDS ALONG WITH HIS TAPE OF TIDAL
C       AMPLITUDES AND PHASES
C
C
C  INPUT--
C
C     IYEAR - EX. 79 FOR 1979
C     DAY - DAY OF YEAR GREENWICH TIME
C                      EXAMPLE 32.5 FOR FEB 1   12 NOON
C                              1.25 FOR JAN 1    6 AM
C
C  OUTPUT--
C
C     ANGLE - ANGULAR ARGUMENT FOR SCHWIDERSKI COMPUTATION
C
C***********************************************************
C
C
C              C A U T I O N
C
C  OCEAN LOADING PHASES COMPUTED FROM SCHWIDERSKI'S MODELS
C  REFER TO THE PHASE OF THE ASSOCIATED SOLID EARTH TIDE
C  GENERATING POTENTIAL AT THE ZERO MERIDIAN ACCORDING TO
C
C      OL_DR = OL_AMP ' COS (SE_PHASE" - OL_PHASE)
C
C  WHERE OL = OCEAN LOADING TIDE,
C        SE = SOLID EARTH TIDE GENERATING POTENTIAL.
C
C  IF THE HARMONIC TIDE DEVELOPMENT OF CARTWRIGHT, ET AL.
C  ( = CTE) (1971, 1973) IS USED, MAKE SURE THAT SE_PHASE"
C  TAKES INTO ACCOUNT
C
C  (1) THE SIGN OF SE_AMP IN THE TABLES OF CARTWRIGHT ET AL.
C
C  (2) THAT CTE'S SE_PHASE REFERS TO A SINE RATHER THAN A
C      COSINE FUNCTION IF (N+M) = (DEGREE + ORDER) OF THE
C      TIDE SPHERICAL HARMONIC IS ODD.
C
C  I.E. SE_PHASE" = TAU(T) ' N1 + S(T) ' N2 + H(T) ' N3
C                 + P(T) ' N4 + N'(T) ' N5 + PS(T) ' N6
C                 + PI   IF CTE'S AMPLITUDE COEFFICIENT < 0
C                 + PI/2 IF (DEGREE + N1) IS ODD
C
C  WHERE TAU ... PS = ASTRONOMICAL ARGUMENTS,
C         N1 ... N6 = CTE'S ARGUMENT NUMBERS.
C
C  MOST TIDE GENERATING SOFTWARE COMPUTE SE_PHASE" (FOR
C  USE WITH COSINES).
C
C  THIS SUBROUTINE IS VALID ONLY AFTER 1973.
C
C*******************************************************************
      SUBROUTINE ARG(IYEAR,DAY,ANGLE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      REAL ANGFAC(4,11)
      DIMENSION ANGLE(11),SPEED(11)
C
C  SPEED OF ALL TERMS IN RADIANS PER SEC
C
      EQUIVALENCE (SPEED(1),SIGM2),(SPEED(2),SIGS2),(SPEED(3),SIGN2)
      EQUIVALENCE (SPEED(4),SIGK2),(SPEED(5),SIGK1),(SPEED(6),SIGO1)
      EQUIVALENCE (SPEED(7),SIGP1),(SPEED(8),SIGQ1),(SPEED(9),SIGMF)
      EQUIVALENCE (SPEED(10),SIGMM),(SPEED(11),SIGSSA)
      DATA SIGM2/1.40519D-4/
      DATA SIGS2/1.45444D-4/
      DATA SIGN2/1.37880D-4/
      DATA SIGK2/1.45842D-4/
      DATA SIGK1/.72921D-4/
      DATA SIGO1/.67598D-4/
      DATA SIGP1/.72523D-4/
      DATA SIGQ1/.64959D-4/
      DATA SIGMF/.053234D-4/
      DATA SIGMM/.026392D-4/
      DATA SIGSSA/.003982D-4/
      DATA ANGFAC/2.E0,-2.E0,0.E0,0.E0,4*0.E0,
     .            2.E0,-3.E0,1.E0,0.E0,2.E0,3*0.E0,
     .            1.E0,2*0.E0,.25E0,1.E0,-2.E0,0.E0,-.25E0,
     .            -1.E0,2*0.E0,-.25E0,1.E0,-3.E0,1.E0,-.25E0,
     .            0.E0,2.E0,2*0.E0,0.E0,1.E0,-1.E0,0.E0,
     .            2.E0,3*0.E0/
      DATA TWOPI/6.28318530718D0/
      DATA DTR/.174532925199D-1/
C
C  DAY OF YEAR
C
      ID=DAY
C
C  FRACTIONAL PART OF DAY IN SECONDS
C
      FDAY=(DAY-ID)*86400.D0
      ICAPD=ID+365*(IYEAR-75)+((IYEAR-73)/4)
      CAPT=(27392.500528D0+1.000000035D0*ICAPD)/36525.D0
C
C MEAN LONGITUDE OF SUN AT BEGINNING OF DAY
C
      H0=(279.69668D0+(36000.768930485D0+3.03D-4*CAPT)*CAPT)*DTR
C
C MEAN LONGITUDE OF MOON AT BEGINNING OF DAY
C
      S0=(((1.9D-6*CAPT-.001133D0)*CAPT+481267.88314137D0)*CAPT
     .  +270.434358D0)*DTR
C
C MEAN LONGITUDE OF LUNAR PERIGEE AT BEGINNING OF DAY
C
      P0=(((-1.2D-5*CAPT-.010325D0)*CAPT+4069.0340329577D0)*CAPT
     .  +334.329653D0)*DTR
      DO 500 K=1,11
      ANGLE(K)=SPEED(K)*FDAY+ANGFAC(1,K)*H0+ANGFAC(2,K)*S0
     .  +ANGFAC(3,K)*P0+ANGFAC(4,K)*TWOPI
      ANGLE(K)=DMOD(ANGLE(K),TWOPI)
      IF(ANGLE(K).LT.0.D0)ANGLE(K)=ANGLE(K)+TWOPI
  500 CONTINUE
      RETURN
      END
