c     main program
      implicit double precision (a-h,o-z)
      double precision lest
c     driver of the function "lest" giving the periodic part of TCB-TT
      epoch=2443144.5d0
      f2000=2451545.5d0
      fjd0=f2000-36500.d0*0.4
      fjd1=f2000
      step=100.d0
      ispan=(fjd1-fjd0)/step
      write(*,*) "fjd0=", fjd0
      write(*,*) "fjd1=", fjd1
      write(*,*) "ispan=", ispan
      write(*,*) "step=", step
      x0=lest(epoch)
      write(*,*) "base=", x0
      write(*,61) "JD", "FBL"
   61 format(t5, a, t15, a)
      do 10 i=1,ispan
      t=fjd0+(i-1)*step
      x=lest(t)
      write(*,60)  t, x
   60 format(f10.1,f15.8)
   10 continue
      stop
      end
      double precision function lest(fjd)
c Provide TDB-TDT by Fairhead, Bretagnon & Lestrade
c Extended Version transmitted by A. Irwin
      implicit double precision (a-h,o-z)
      real*16 tdt
c     write(*,*) "fjd=", fjd
      tdt=fjd
      call trans(tdt, ctatv)
      lest=ctatv*1.d6
c     write(*,*) "lest=",lest
      return
      end
	subroutine TRANS(tdt,ctatv)
c	Fairhead et al 1 ns routine originally obtained from Joe Taylor 1995
c	with input slightly modified.
c	tdt is quadruple precision TDT.
c	returned value is ctatv = TDB - TDT in secs.
	implicit real*8(a-h,o-z)
	real*16 tdt
	T=(tdt-2451545.q0)/365.25q3
        TT = T*T
        TTT = T*TT
        TTTT = T*TTT

c T**0
      t1= 1656.674564 * SIN(   6283.075849991 *T + 6.240054195 )+
     & 22.417471 * SIN(   5753.384884897 *T + 4.296977442 )  +
     & 13.839792 * SIN(  12566.151699983 *T + 6.196904410 )  +
     & 4.770086 * SIN(    529.690965095 *T + 0.444401603 )   +
     & 4.676740 * SIN(   6069.776754553 *T + 4.021195093 )   +
     & 2.256707 * SIN(    213.299095438 *T + 5.543113262 )   +
     & 1.694205 * SIN(     -3.523118349 *T + 5.025132748 )   +
     & 1.554905 * SIN(  77713.771467920 *T + 5.198467090 )   +
     & 1.276839 * SIN(   7860.419392439 *T + 5.988822341 )   +
     & 1.193379 * SIN(   5223.693919802 *T + 3.649823730 )   +
     & 1.115322 * SIN(   3930.209696220 *T + 1.422745069 )   +
     & 0.794185 * SIN(  11506.769769794 *T + 2.322313077 )   +
     & 0.447061 * SIN(     26.298319800 *T + 3.615796498 )   +
     & 0.435206 * SIN(   -398.149003408 *T + 4.349338347 )   +
     & 0.600309 * SIN(   1577.343542448 *T + 2.678271909 )   +
     & 0.496817 * SIN(   6208.294251424 *T + 5.696701824 )   +
     & 0.486306 * SIN(   5884.926846583 *T + 0.520007179 )   +
     & 0.432392 * SIN(     74.781598567 *T + 2.435898309 )   +
     & 0.468597 * SIN(   6244.942814354 *T + 5.866398759 )   +
     & 0.375510 * SIN(   5507.553238667 *T + 4.103476804 )   
      t2= 0.243085 * SIN(   -775.522611324 *T + 3.651837925 )   +
     & 0.173435 * SIN(  18849.227549974 *T + 6.153743485 )   +
     & 0.230685 * SIN(   5856.477659115 *T + 4.773852582 )   +
     & 0.203747 * SIN(  12036.460734888 *T + 4.333987818 )   +
     & 0.143935 * SIN(   -796.298006816 *T + 5.957517795 )   +
     & 0.159080 * SIN(  10977.078804699 *T + 1.890075226 )   +
     & 0.119979 * SIN(     38.133035638 *T + 4.551585768 )   +
     & 0.118971 * SIN(   5486.777843175 *T + 1.914547226 )   +
     & 0.116120 * SIN(   1059.381930189 *T + 0.873504123 )   +
     & 0.137927 * SIN(  11790.629088659 *T + 1.135934669 )   +
     & 0.098358 * SIN(   2544.314419883 *T + 0.092793886 )   +
     & 0.101868 * SIN(  -5573.142801634 *T + 5.984503847 )   +
     & 0.080164 * SIN(    206.185548437 *T + 2.095377709 )   +
     & 0.079645 * SIN(   4694.002954708 *T + 2.949233637 )   +
     & 0.062617 * SIN(     20.775395492 *T + 2.654394814 )   +
     & 0.075019 * SIN(   2942.463423292 *T + 4.980931759 )   +
     & 0.064397 * SIN(   5746.271337896 *T + 1.280308748 )   +
     & 0.063814 * SIN(   5760.498431898 *T + 4.167901731 )   +
     & 0.048042 * SIN(   2146.165416475 *T + 1.495846011 )   +
     & 0.048373 * SIN(    155.420399434 *T + 2.251573730 )   
      t3= 0.058844 * SIN(    426.598190876 *T + 4.839650148 )   +
     & 0.046551 * SIN(     -0.980321068 *T + 0.921573539 )   +
     & 0.054139 * SIN(  17260.154654690 *T + 3.411091093 )   +
     & 0.042411 * SIN(   6275.962302991 *T + 2.869567043 )   +
     & 0.040184 * SIN(     -7.113547001 *T + 3.565975565 )   +
     & 0.036564 * SIN(   5088.628839767 *T + 3.324679049 )   +
     & 0.040759 * SIN(  12352.852604545 *T + 3.981496998 )   +
     & 0.036507 * SIN(    801.820931124 *T + 6.248866009 )   +
     & 0.036955 * SIN(   3154.687084896 *T + 5.071801441 )   +
     & 0.042732 * SIN(    632.783739313 *T + 5.720622217 )   +
     & 0.042560 * SIN( 161000.685737473 *T + 1.270837679 )   +
     & 0.040480 * SIN(  15720.838784878 *T + 2.546610123 )   +
     & 0.028244 * SIN(  -6286.598968340 *T + 5.069663519 )   +
     & 0.033477 * SIN(   6062.663207553 *T + 4.144987272 )   +
     & 0.034867 * SIN(    522.577418094 *T + 5.210064075 )   +
     & 0.032438 * SIN(   6076.890301554 *T + 0.749317412 )   +
     & 0.030215 * SIN(   7084.896781115 *T + 3.389610345 )   +
     & 0.029247 * SIN( -71430.695617928 *T + 4.183178762 )   +
     & 0.033529 * SIN(   9437.762934887 *T + 2.404714239 )   +
     & 0.032423 * SIN(   8827.390269875 *T + 5.541473556 )   
      t4= 0.027567 * SIN(   6279.552731642 *T + 5.040846034 )   +
     & 0.029862 * SIN(  12139.553509107 *T + 1.770181024 )   +
     & 0.022509 * SIN(  10447.387839604 *T + 1.460726241 )   +
     & 0.020937 * SIN(   8429.241266467 *T + 0.652303414 )   +
     & 0.020322 * SIN(    419.484643875 *T + 3.735430632 )   +
     & 0.024816 * SIN(  -1194.447010225 *T + 1.087136918 )   +
     & 0.025196 * SIN(   1748.016413067 *T + 2.901883301 )   +
     & 0.021691 * SIN(  14143.495242431 *T + 5.952658009 )   +
     & 0.017673 * SIN(   6812.766815086 *T + 3.186129845 )   +
     & 0.022567 * SIN(   6133.512652857 *T + 3.307984806 )   +
     & 0.016155 * SIN(  10213.285546211 *T + 1.331103168 )   +
     & 0.014751 * SIN(   1349.867409659 *T + 4.308933301 )   +
     & 0.015949 * SIN(   -220.412642439 *T + 4.005298270 )   +
     & 0.015974 * SIN(  -2352.866153772 *T + 6.145309371 )   +
     & 0.014223 * SIN(  17789.845619785 *T + 2.104551349 )   +
     & 0.017806 * SIN(     73.297125859 *T + 3.475975097 )   +
     & 0.013671 * SIN(   -536.804512095 *T + 5.971672571 )   +
     & 0.011942 * SIN(   8031.092263058 *T + 2.053414715 )   +
     & 0.014318 * SIN(  16730.463689596 *T + 3.016058075 )   +
     & 0.012462 * SIN(    103.092774219 *T + 1.737438797 )   
      t5= 0.010962 * SIN(      3.590428652 *T + 2.196567739 )   +
     & 0.015078 * SIN(  19651.048481098 *T + 3.969480770 )   +
     & 0.010396 * SIN(    951.718406251 *T + 5.717799605 )   +
     & 0.011707 * SIN(  -4705.732307544 *T + 2.654125618 )   +
     & 0.010453 * SIN(   5863.591206116 *T + 1.913704550 )   +
     & 0.012420 * SIN(   4690.479836359 *T + 4.734090399 )   +
     & 0.011847 * SIN(   5643.178563677 *T + 5.489005403 )   +
     & 0.008610 * SIN(   3340.612426700 *T + 3.661698944 )   +
     & 0.011622 * SIN(   5120.601145584 *T + 4.863931876 )   +
     & 0.010825 * SIN(    553.569402842 *T + 0.842715011 )   +
     & 0.008666 * SIN(   -135.065080035 *T + 3.293406547 )   +
     & 0.009963 * SIN(    149.563197135 *T + 4.870690598 )   +
     & 0.009858 * SIN(   6309.374169791 *T + 1.061816410 )   +
     & 0.007959 * SIN(    316.391869657 *T + 2.465042647 )   +
     & 0.010099 * SIN(    283.859318865 *T + 1.942176992 )   +
     & 0.007147 * SIN(   -242.728603974 *T + 3.661486981 )   +
     & 0.007505 * SIN(   5230.807466803 *T + 4.920937029 )   +
     & 0.008323 * SIN(  11769.853693166 *T + 1.229392026 )   +
     & 0.007490 * SIN(  -6256.777530192 *T + 3.658444681 )   +
     & 0.009370 * SIN( 149854.400134205 *T + 0.673880395 )   
      t6= 0.007117 * SIN(     38.027672636 *T + 5.294249518 )   +
     & 0.007857 * SIN(  12168.002696575 *T + 0.525733528 )   +
     & 0.007019 * SIN(   6206.809778716 *T + 0.837688810 )   +
     & 0.006056 * SIN(    955.599741609 *T + 4.194535082 )   +
     & 0.008107 * SIN(  13367.972631107 *T + 3.793235253 )   +
     & 0.006731 * SIN(   5650.292110678 *T + 5.639906583 )   +
     & 0.007332 * SIN(     36.648562930 *T + 0.114858677 )   +
     & 0.006366 * SIN(   4164.311989613 *T + 2.262081818 )   +
     & 0.006858 * SIN(   5216.580372801 *T + 0.642063318 )   +
     & 0.006919 * SIN(   6681.224853400 *T + 6.018501522 )   +
     & 0.006826 * SIN(   7632.943259650 *T + 3.458654112 )   +
     & 0.005308 * SIN(  -1592.596013633 *T + 2.500382359 )   +
     & 0.005096 * SIN(  11371.704689758 *T + 2.547107806 )   +
     & 0.004841 * SIN(   5333.900241022 *T + 0.437078094 )   +
     & 0.005582 * SIN(   5966.683980335 *T + 2.246174308 )   +
     & 0.006304 * SIN(  11926.254413669 *T + 2.512929171 )   +
     & 0.006603 * SIN(  23581.258177318 *T + 5.393136889 )   +
     & 0.005123 * SIN(     -1.484472708 *T + 2.999641028 )   +
     & 0.004648 * SIN(   1589.072895284 *T + 1.275847090 )   +
     & 0.005119 * SIN(   6438.496249426 *T + 1.486539246 )   
      t7= 0.004521 * SIN(   4292.330832950 *T + 6.140635794 )   +
     & 0.005680 * SIN(  23013.539539587 *T + 4.557814849 )   +
     & 0.005488 * SIN(     -3.455808046 *T + 0.090675389 )   +
     & 0.004193 * SIN(   7234.794256242 *T + 4.869091389 )   +
     & 0.003742 * SIN(   7238.675591600 *T + 4.691976180 )   +
     & 0.004148 * SIN(   -110.206321219 *T + 3.016173439 )   +
     & 0.004553 * SIN(  11499.656222793 *T + 5.554998314 )   +
     & 0.004892 * SIN(   5436.993015240 *T + 1.475415597 )   +
     & 0.004044 * SIN(   4732.030627343 *T + 1.398784824 )   +
     & 0.004164 * SIN(  12491.370101415 *T + 5.650931916 )   +
     & 0.004349 * SIN(  11513.883316794 *T + 2.181745369 )   +
     & 0.003919 * SIN(  12528.018664345 *T + 5.823319737 )   +
     & 0.003129 * SIN(   6836.645252834 *T + 0.003844094 )   +
     & 0.004080 * SIN(  -7058.598461315 *T + 3.690360123 )   +
     & 0.003270 * SIN(     76.266071276 *T + 1.517189902 )   +
     & 0.002954 * SIN(   6283.143160294 *T + 4.447203799 )   +
     & 0.002872 * SIN(     28.449187468 *T + 1.158692983 )   +
     & 0.002881 * SIN(    735.876513532 *T + 0.349250250 )   +
     & 0.003279 * SIN(   5849.364112115 *T + 4.893384368 )   +
     & 0.003625 * SIN(   6209.778724132 *T + 1.473760578 )   
      t8= 0.003074 * SIN(    949.175608970 *T + 5.185878737 )   +
     & 0.002775 * SIN(   9917.696874510 *T + 1.030026325 )   +
     & 0.002646 * SIN(  10973.555686350 *T + 3.918259169 )   +
     & 0.002575 * SIN(  25132.303399966 *T + 6.109659023 )   +
     & 0.003500 * SIN(    263.083923373 *T + 1.892100742 )   +
     & 0.002740 * SIN(  18319.536584880 *T + 4.320519510 )   +
     & 0.002464 * SIN(    202.253395174 *T + 4.698203059 )   +
     & 0.002409 * SIN(      2.542797281 *T + 5.325009315 )   +
     & 0.003354 * SIN( -90955.551694697 *T + 1.942656623 )   +
     & 0.002296 * SIN(   6496.374945429 *T + 5.061810696 )   +
     & 0.003002 * SIN(   6172.869528772 *T + 2.797822767 )   +
     & 0.003202 * SIN(  27511.467873537 *T + 0.531673101 )   +
     & 0.002954 * SIN(  -6283.008539689 *T + 4.533471191 )   +
     & 0.002353 * SIN(    639.897286314 *T + 3.734548088 )   +
     & 0.002401 * SIN(  16200.772724501 *T + 2.605547070 )   +
     & 0.003053 * SIN( 233141.314403759 *T + 3.029030662 )   +
     & 0.003024 * SIN(  83286.914269554 *T + 2.355556099 )   +
     & 0.002863 * SIN(  17298.182327326 *T + 5.240963796 )   +
     & 0.002103 * SIN(  -7079.373856808 *T + 5.756641637 )   +
     & 0.002303 * SIN(  83996.847317911 *T + 2.013686814 )   
      t9= 0.002303 * SIN(  18073.704938650 *T + 1.089100410 )   +
     & 0.002381 * SIN(     63.735898303 *T + 0.759188178 )   +
     & 0.002493 * SIN(   6386.168624210 *T + 0.645026535 )   +
     & 0.002366 * SIN(      3.932153263 *T + 6.215885448 )   +
     & 0.002169 * SIN(  11015.106477335 *T + 4.845297676 )   +
     & 0.002397 * SIN(   6243.458341645 *T + 3.809290043 )   +
     & 0.002183 * SIN(   1162.474704408 *T + 6.179611691 )   +
     & 0.002353 * SIN(   6246.427287062 *T + 4.781719760 )   +
     & 0.002199 * SIN(   -245.831646229 *T + 5.956152284 )   +
     & 0.001729 * SIN(   3894.181829542 *T + 1.264976635 )   +
     & 0.001896 * SIN(  -3128.388765096 *T + 4.914231596 )   +
     & 0.002085 * SIN(     35.164090221 *T + 1.405158503 )   +
     & 0.002024 * SIN(  14712.317116458 *T + 2.752035928 )   +
     & 0.001737 * SIN(   6290.189396992 *T + 5.280820144 )   +
     & 0.002229 * SIN(    491.557929457 *T + 1.571007057 )   +
     & 0.001602 * SIN(  14314.168113050 *T + 4.203664806 )   +
     & 0.002186 * SIN(    454.909366527 *T + 1.402101526 )   +
     & 0.001897 * SIN(  22483.848574493 *T + 4.167932508 )   +
     & 0.001825 * SIN(  -3738.761430108 *T + 0.545828785 )   +
     & 0.001894 * SIN(   1052.268383188 *T + 5.817167450 )   
      t10= 0.001421 * SIN(     20.355319399 *T + 2.419886601 )   +
     & 0.001408 * SIN(  10984.192351700 *T + 2.732084787 )   +
     & 0.001847 * SIN(  10873.986030480 *T + 2.903477885 )   +
     & 0.001391 * SIN(  -8635.942003763 *T + 0.593891500 )   +
     & 0.001388 * SIN(     -7.046236698 *T + 1.166145902 )   +
     & 0.001810 * SIN( -88860.057071188 *T + 0.487355242 )   +
     & 0.001288 * SIN(  -1990.745017041 *T + 3.913022880 )   +
     & 0.001297 * SIN(  23543.230504682 *T + 3.063805171 )   +
     & 0.001335 * SIN(   -266.607041722 *T + 3.995764039 )   +
     & 0.001376 * SIN(  10969.965257698 *T + 5.152914309 )   +
     & 0.001745 * SIN( 244287.600007027 *T + 3.626395673 )   +
     & 0.001649 * SIN(  31441.677569757 *T + 1.952049260 )   +
     & 0.001416 * SIN(   9225.539273283 *T + 4.996408389 )   +
     & 0.001238 * SIN(   4804.209275927 *T + 5.503379738 )   +
     & 0.001472 * SIN(   4590.910180489 *T + 4.164913291 )   +
     & 0.001169 * SIN(   6040.347246017 *T + 5.841719038 )   +
     & 0.001039 * SIN(   5540.085789459 *T + 2.769753519 )   +
     & 0.001004 * SIN(   -170.672870619 *T + 0.755008103 )   +
     & 0.001284 * SIN(  10575.406682942 *T + 5.306538209 )   +
     & 0.001278 * SIN(     71.812653151 *T + 4.713486491 )   
      t11= 0.001321 * SIN(  18209.330263660 *T + 2.624866359 )   +
     & 0.001297 * SIN(  21228.392023546 *T + 0.382603541 )   +
     & 0.000954 * SIN(   6282.095528923 *T + 0.882213514 )   +
     & 0.001145 * SIN(   6058.731054289 *T + 1.169483931 )   +
     & 0.000979 * SIN(   5547.199336460 *T + 5.448375984 )   +
     & 0.000987 * SIN(  -6262.300454499 *T + 2.656486959 )   +
     & 0.001070 * SIN(-154717.609887482 *T + 1.827624012 )   +
     & 0.000991 * SIN(   4701.116501708 *T + 4.387001801 )   +
     & 0.001155 * SIN(    -14.227094002 *T + 3.042700750 )   +
     & 0.001176 * SIN(    277.034993741 *T + 3.335519004 )   +
     & 0.000890 * SIN(  13916.019109642 *T + 5.601498297 )   +
     & 0.000884 * SIN(  -1551.045222648 *T + 1.088831705 )   +
     & 0.000876 * SIN(   5017.508371365 *T + 3.969902609 )   +
     & 0.000806 * SIN(  15110.466119866 *T + 5.142876744 )   +
     & 0.000773 * SIN(  -4136.910433516 *T + 0.022067765 )   +
     & 0.001077 * SIN(    175.166059800 *T + 1.844913056 )   +
     & 0.000954 * SIN(  -6284.056171060 *T + 0.968480906 )   +
     & 0.000737 * SIN(   5326.786694021 *T + 4.923831588 )   +
     & 0.000845 * SIN(   -433.711737877 *T + 4.749245231 )   +
     & 0.000819 * SIN(   8662.240323563 *T + 5.991247817 )   
      t12= 0.000852 * SIN(    199.072001436 *T + 2.189604979 )   +
     & 0.000723 * SIN(  17256.631536341 *T + 6.068719637 )   +
     & 0.000940 * SIN(   6037.244203762 *T + 6.197428148 )   +
     & 0.000885 * SIN(  11712.955318231 *T + 3.280414875 )   +
     & 0.000706 * SIN(  12559.038152982 *T + 2.824848947 )   +
     & 0.000732 * SIN(   2379.164473572 *T + 2.501813417 )   +
     & 0.000764 * SIN(  -6127.655450557 *T + 2.236346329 )   +
     & 0.000908 * SIN(    131.541961686 *T + 2.521257490 )   +
     & 0.000907 * SIN(  35371.887265976 *T + 3.370195967 )   +
     & 0.000673 * SIN(   1066.495477190 *T + 3.876512374 )   +
     & 0.000814 * SIN(  17654.780539750 *T + 4.627122566 )   +
     & 0.000630 * SIN(     36.027866677 *T + 0.156368499 )   +
     & 0.000798 * SIN(    515.463871093 *T + 5.151962502 )   +
     & 0.000798 * SIN(    148.078724426 *T + 5.909225055 )   +
     & 0.000806 * SIN(    309.278322656 *T + 6.054064447 )   +
     & 0.000607 * SIN(    -39.617508346 *T + 2.839021623 )   +
     & 0.000601 * SIN(    412.371096874 *T + 3.984225404 )   +
     & 0.000646 * SIN(  11403.676995575 *T + 3.852959484 )   +
     & 0.000704 * SIN(  13521.751441591 *T + 2.300991267 )   +
     & 0.000603 * SIN( -65147.619767937 *T + 4.140083146 )   
      t13= 0.000609 * SIN(  10177.257679534 *T + 0.437122327 )   +
     & 0.000631 * SIN(   5767.611978898 *T + 4.026532329 )   +
     & 0.000576 * SIN(  11087.285125918 *T + 4.760293101 )   +
     & 0.000674 * SIN(  14945.316173554 *T + 6.270510511 )   +
     & 0.000726 * SIN(   5429.879468239 *T + 6.039606892 )   +
     & 0.000710 * SIN(  28766.924424484 *T + 5.672617711 )   +
     & 0.000647 * SIN(  11856.218651625 *T + 3.397132627 )   +
     & 0.000678 * SIN(  -5481.254918868 *T + 6.249666675 )   +
     & 0.000618 * SIN(  22003.914634870 *T + 2.466427018 )   +
     & 0.000738 * SIN(   6134.997125565 *T + 2.242668890 )   +
     & 0.000660 * SIN(    625.670192312 *T + 5.864091907 )   +
     & 0.000694 * SIN(   3496.032826134 *T + 2.668309141 )   +
     & 0.000531 * SIN(   6489.261398429 *T + 1.681888780 )   +
     & 0.000611 * SIN(-143571.324284214 *T + 2.424978312 )   +
     & 0.000575 * SIN(  12043.574281889 *T + 4.216492400 )   +
     & 0.000553 * SIN(  12416.588502848 *T + 4.772158039 )   +
     & 0.000689 * SIN(   4686.889407707 *T + 6.224271088 )   +
     & 0.000495 * SIN(   7342.457780181 *T + 3.817285811 )   +
     & 0.000567 * SIN(   3634.621024518 *T + 1.649264690 )   +
     & 0.000515 * SIN(  18635.928454536 *T + 3.945345892 )   
      t14= 0.000486 * SIN(   -323.505416657 *T + 4.061673868 )   +
     & 0.000662 * SIN(  25158.601719765 *T + 1.794058369 )   +
     & 0.000509 * SIN(    846.082834751 *T + 3.053874588 )   +
     & 0.000472 * SIN( -12569.674818332 *T + 5.112133338 )   +
     & 0.000461 * SIN(   6179.983075773 *T + 0.513669325 )   +
     & 0.000641 * SIN(  83467.156352816 *T + 3.210727723 )   +
     & 0.000520 * SIN(  10344.295065386 *T + 2.445597761 )   +
     & 0.000493 * SIN(  18422.629359098 *T + 1.676939306 )   +
     & 0.000478 * SIN(   1265.567478626 *T + 5.487314569 )   +
     & 0.000472 * SIN(    -18.159247265 *T + 1.999707589 )   +
     & 0.000559 * SIN(  11190.377900137 *T + 5.783236356 )   +
     & 0.000494 * SIN(   9623.688276691 *T + 3.022645053 )   +
     & 0.000463 * SIN(   5739.157790895 *T + 1.411223013 )   +
     & 0.000432 * SIN(  16858.482532933 *T + 1.179256434 )   +
     & 0.000574 * SIN(  72140.628666286 *T + 1.758191830 )   +
     & 0.000484 * SIN(  17267.268201691 *T + 3.290589143 )   +
     & 0.000550 * SIN(   4907.302050146 *T + 0.864024298 )   +
     & 0.000399 * SIN(     14.977853527 *T + 2.094441910 )   +
     & 0.000491 * SIN(    224.344795702 *T + 0.878372791 )   +
     & 0.000432 * SIN(  20426.571092422 *T + 6.003829241 )   
       t15= 0.000481 * SIN(   5749.452731634 *T + 4.309591964 )   +
     & 0.000480 * SIN(   5757.317038160 *T + 1.142348571 )   +
     & 0.000485 * SIN(   6702.560493867 *T + 0.210580917 )   +
     & 0.000426 * SIN(   6055.549660552 *T + 4.274476529 )   +
     & 0.000480 * SIN(   5959.570433334 *T + 5.031351030 )   +
     & 0.000466 * SIN(  12562.628581634 *T + 4.959581597 )   +
     & 0.000520 * SIN(  39302.096962196 *T + 4.788002889 )   +
     & 0.000458 * SIN(  12132.439962106 *T + 1.880103788 )   +
     & 0.000470 * SIN(  12029.347187887 *T + 1.405611197 )   +
     & 0.000416 * SIN(  -7477.522860216 *T + 1.082356330 )   +
     & 0.000449 * SIN(  11609.862544012 *T + 4.179989585 )   +
     & 0.000465 * SIN(  17253.041107690 *T + 0.353496295 )   +
     & 0.000362 * SIN(  -4535.059436924 *T + 1.583849576 )   +
     & 0.000383 * SIN(  21954.157609398 *T + 3.747376371 )   +
     & 0.000389 * SIN(     17.252277143 *T + 1.395753179 )   +
     & 0.000331 * SIN(  18052.929543158 *T + 0.566790582 )   +
     & 0.000430 * SIN(  13517.870106233 *T + 0.685827538 )   +
     & 0.000368 * SIN(  -5756.908003246 *T + 0.731374317 )   +
     & 0.000330 * SIN(  10557.594160824 *T + 3.710043680 )   +
     & 0.000332 * SIN(  20199.094959633 *T + 1.652901407 )   
      t16= 0.000384 * SIN(  11933.367960670 *T + 5.827781531 )   +
     & 0.000387 * SIN(  10454.501386605 *T + 2.541182564 )   +
     & 0.000325 * SIN(  15671.081759407 *T + 2.178850542 )   +
     & 0.000318 * SIN(    138.517496871 *T + 2.253253037 )   +
     & 0.000305 * SIN(   9388.005909415 *T + 0.578340206 )   +
     & 0.000352 * SIN(   5749.861766548 *T + 3.000297967 )   +
     & 0.000311 * SIN(   6915.859589305 *T + 1.693574249 )   +
     & 0.000297 * SIN(  24072.921469776 *T + 1.997249392 )   +
     & 0.000363 * SIN(   -640.877607382 *T + 5.071820966 )   +
     & 0.000323 * SIN(  12592.450019783 *T + 1.072262823 )   +
     & 0.000341 * SIN(  12146.667056108 *T + 4.700657997 )   +
     & 0.000290 * SIN(   9779.108676125 *T + 1.812320441 )   +
     & 0.000342 * SIN(   6132.028180148 *T + 4.322238614 )   +
     & 0.000329 * SIN(   6268.848755990 *T + 3.033827743 )   +
     & 0.000374 * SIN(  17996.031168222 *T + 3.388716544 )   +
     & 0.000285 * SIN(   -533.214083444 *T + 4.687313233 )   +
     & 0.000338 * SIN(   6065.844601290 *T + 0.877776108 )   +
     & 0.000276 * SIN(     24.298513841 *T + 0.770299429 )   +
     & 0.000336 * SIN(  -2388.894020449 *T + 5.353796034 )   +
     & 0.000290 * SIN(   3097.883822726 *T + 4.075291557 )   
      t17= 0.000318 * SIN(    709.933048357 *T + 5.941207518 )   +
     & 0.000271 * SIN(  13095.842665077 *T + 3.208912203 )   +
     & 0.000331 * SIN(   6073.708907816 *T + 4.007881169 )   +
     & 0.000292 * SIN(    742.990060533 *T + 2.714333592 )   +
     & 0.000362 * SIN(  29088.811415985 *T + 3.215977013 )   +
     & 0.000280 * SIN(  12359.966151546 *T + 0.710872502 )   +
     & 0.000267 * SIN(  10440.274292604 *T + 4.730108488 )   +
     & 0.000262 * SIN(    838.969287750 *T + 1.327720272 )   +
     & 0.000250 * SIN(  16496.361396202 *T + 0.898769761 )   +
     & 0.000325 * SIN(  20597.243963041 *T + 0.180044365 )   +
     & 0.000268 * SIN(   6148.010769956 *T + 5.152666276 )   +
     & 0.000284 * SIN(   5636.065016677 *T + 5.655385808 )   +
     & 0.000301 * SIN(   6080.822454817 *T + 2.135396205 )   +
     & 0.000294 * SIN(   -377.373607916 *T + 3.708784168 )   +
     & 0.000236 * SIN(   2118.763860378 *T + 1.733578756 )   +
     & 0.000234 * SIN(   5867.523359379 *T + 5.575209112 )   +
     & 0.000268 * SIN(-226858.238553767 *T + 0.069432392 )   +
     & 0.000265 * SIN( 167283.761587465 *T + 4.369302826 )   +
     & 0.000280 * SIN(  28237.233459389 *T + 5.304829118 )   +
     & 0.000292 * SIN(  12345.739057544 *T + 4.096094132 )   
      t18= 0.000223 * SIN(  19800.945956225 *T + 3.069327406 )   +
     & 0.000301 * SIN(  43232.306658416 *T + 6.205311188 )   +
     & 0.000264 * SIN(  18875.525869774 *T + 1.417263408 )   +
     & 0.000304 * SIN(  -1823.175188677 *T + 3.409035232 )   +
     & 0.000301 * SIN(    109.945688789 *T + 0.510922054 )   +
     & 0.000260 * SIN(    813.550283960 *T + 2.389438934 )   +
     & 0.000299 * SIN( 316428.228673312 *T + 5.384595078 )   +
     & 0.000211 * SIN(   5756.566278634 *T + 3.789392838 )   +
     & 0.000209 * SIN(   5750.203491159 *T + 1.661943545 )   +
     & 0.000240 * SIN(  12489.885628707 *T + 5.684549045 )   +
     & 0.000216 * SIN(   6303.851245484 *T + 3.862942261 )   +
     & 0.000203 * SIN(   1581.959348283 *T + 5.549853589 )   +
     & 0.000200 * SIN(   5642.198242609 *T + 1.016115785 )   +
     & 0.000197 * SIN(    -70.849445304 *T + 4.690702525 )   +
     & 0.000227 * SIN(   6287.008003254 *T + 2.911891613 )   +
     & 0.000197 * SIN(    533.623118358 *T + 1.048982898 )   +
     & 0.000205 * SIN(  -6279.485421340 *T + 1.829362730 )   +
     & 0.000209 * SIN( -10988.808157535 *T + 2.636140084 )   +
     & 0.000208 * SIN(   -227.526189440 *T + 4.127883842 )   +
     & 0.000191 * SIN(    415.552490612 *T + 4.401165650 )   
      t19= 0.000190 * SIN(  29296.615389579 *T + 4.175658539 )   +
     & 0.000264 * SIN(  66567.485864652 *T + 4.601102551 )   +
     & 0.000256 * SIN(  -3646.350377354 *T + 0.506364778 )   +
     & 0.000188 * SIN(  13119.721102825 *T + 2.032195842 )   +
     & 0.000185 * SIN(   -209.366942175 *T + 4.694756586 )   +
     & 0.000198 * SIN(  25934.124331089 *T + 3.832703118 )   +
     & 0.000195 * SIN(   4061.219215394 *T + 3.308463427 )   +
     & 0.000234 * SIN(   5113.487598583 *T + 1.716090661 )   +
     & 0.000188 * SIN(   1478.866574064 *T + 5.686865780 )   +
     & 0.000222 * SIN(  11823.161639450 *T + 1.942386641 )   +
     & 0.000181 * SIN(  10770.893256262 *T + 1.999482059 )   +
     & 0.000171 * SIN(   6546.159773364 *T + 1.182807992 )   +
     & 0.000206 * SIN(     70.328180442 *T + 5.934076062 )   +
     & 0.000169 * SIN(  20995.392966449 *T + 2.169080622 )   +
     & 0.000191 * SIN(  10660.686935042 *T + 5.405515999 )   +
     & 0.000228 * SIN(  33019.021112205 *T + 4.656985514 )   +
     & 0.000184 * SIN(  -4933.208440333 *T + 3.327476868 )   +
     & 0.000220 * SIN(   -135.625325010 *T + 1.765430262 )   +
     & 0.000166 * SIN(  23141.558382925 *T + 3.454132746 )   +
     & 0.000191 * SIN(   6144.558353121 *T + 5.020393445 )   
      t20= 0.000180 * SIN(   6084.003848555 *T + 0.602182191 )   +
     & 0.000163 * SIN(  17782.732072784 *T + 4.960593133 )   +
     & 0.000225 * SIN(  16460.333529525 *T + 2.596451817 )   +
     & 0.000222 * SIN(   5905.702242076 *T + 3.731990323 )   +
     & 0.000204 * SIN(    227.476132789 *T + 5.636192701 )   +
     & 0.000159 * SIN(  16737.577236597 *T + 3.600691544 )   +
     & 0.000200 * SIN(   6805.653268085 *T + 0.868220961 )   +
     & 0.000187 * SIN(  11919.140866668 *T + 2.629456641 )   +
     & 0.000161 * SIN(    127.471796607 *T + 2.862574720 )   +
     & 0.000205 * SIN(   6286.666278643 *T + 1.742882331 )   +
     & 0.000189 * SIN(    153.778810485 *T + 4.812372643 )   +
     & 0.000168 * SIN(  16723.350142595 *T + 0.027860588 )   +
     & 0.000149 * SIN(  11720.068865232 *T + 0.659721876 )   +
     & 0.000189 * SIN(   5237.921013804 *T + 5.245313000 )   +
     & 0.000143 * SIN(   6709.674040867 *T + 4.317625647 )   +
     & 0.000146 * SIN(   4487.817406270 *T + 4.815297007 )   +
     & 0.000144 * SIN(   -664.756045130 *T + 5.381366880 )   +
     & 0.000175 * SIN(   5127.714692584 *T + 4.728443327 )   +
     & 0.000162 * SIN(   6254.626662524 *T + 1.435132069 )   +
     & 0.000187 * SIN(  47162.516354635 *T + 1.354371923 )   
      t21= 0.000146 * SIN(  11080.171578918 *T + 3.369695406 )   +
     & 0.000180 * SIN(   -348.924420448 *T + 2.490902145 )   +
     & 0.000148 * SIN(    151.047669843 *T + 3.799109588 )   +
     & 0.000157 * SIN(   6197.248551160 *T + 1.284375887 )   +
     & 0.000167 * SIN(    146.594251718 *T + 0.759969109 )   +
     & 0.000133 * SIN(  -5331.357443741 *T + 5.409701889 )   +
     & 0.000154 * SIN(     95.979227218 *T + 3.366890614 )   +
     & 0.000148 * SIN(  -6418.140930027 *T + 3.384104996 )   +
     & 0.000128 * SIN(  -6525.804453965 *T + 3.803419985 )   +
     & 0.000130 * SIN(  11293.470674356 *T + 0.939039445 )   +
     & 0.000152 * SIN(  -5729.506447149 *T + 0.734117523 )   +
     & 0.000138 * SIN(    210.117701700 *T + 2.564216078 )   +
     & 0.000123 * SIN(   6066.595360816 *T + 4.517099537 )   +
     & 0.000140 * SIN(  18451.078546566 *T + 0.642049130 )   +
     & 0.000126 * SIN(  11300.584221356 *T + 3.485280663 )   +
     & 0.000119 * SIN(  10027.903195729 *T + 3.217431161 )   +
     & 0.000151 * SIN(   4274.518310832 *T + 4.404359108 )   +
     & 0.000117 * SIN(   6072.958148291 *T + 0.366324650 )   +
     & 0.000165 * SIN(  -7668.637425143 *T + 4.298212528 )   +
     & 0.000117 * SIN(  -6245.048177356 *T + 5.379518958 )   
      t22= 0.000130 * SIN(  -5888.449964932 *T + 4.527681115 )   +
     & 0.000121 * SIN(   -543.918059096 *T + 6.109429504 )   +
     & 0.000162 * SIN(   9683.594581116 *T + 5.720092446 )   +
     & 0.000141 * SIN(   6219.339951688 *T + 0.679068671 )   +
     & 0.000118 * SIN(  22743.409379516 *T + 4.881123092 )   +
     & 0.000129 * SIN(   1692.165669502 *T + 0.351407289 )   +
     & 0.000126 * SIN(   5657.405657679 *T + 5.146592349 )   +
     & 0.000114 * SIN(    728.762966531 *T + 0.520791814 )   +
     & 0.000120 * SIN(     52.596639600 *T + 0.948516300 )   +
     & 0.000115 * SIN(     65.220371012 *T + 3.504914846 )   +
     & 0.000126 * SIN(   5881.403728234 *T + 5.577502482 )   +
     & 0.000158 * SIN( 163096.180360983 *T + 2.957128968 )   +
     & 0.000134 * SIN(  12341.806904281 *T + 2.598576764 )   +
     & 0.000151 * SIN(  16627.370915377 *T + 3.985702050 )   +
     & 0.000109 * SIN(   1368.660252845 *T + 0.014730471 )   +
     & 0.000131 * SIN(   6211.263196841 *T + 0.085077024 )   +
     & 0.000146 * SIN(   5792.741760812 *T + 0.708426604 )   +
     & 0.000146 * SIN(    -77.750543984 *T + 3.121576600 )   +
     & 0.000107 * SIN(   5341.013788022 *T + 0.288231904 )   +
     & 0.000138 * SIN(   6281.591377283 *T + 2.797450317 )   
      t23= 0.000113 * SIN(  -6277.552925684 *T + 2.788904128 )   +
     & 0.000115 * SIN(   -525.758811831 *T + 5.895222200 )   +
     & 0.000138 * SIN(   6016.468808270 *T + 6.096188999 )   +
     & 0.000139 * SIN(  23539.707386333 *T + 2.028195445 )   +
     & 0.000146 * SIN(  -4176.041342449 *T + 4.660008502 )   +
     & 0.000107 * SIN(  16062.184526117 *T + 4.066520001 )   +
     & 0.000142 * SIN(  83783.548222473 *T + 2.936315115 )   +
     & 0.000128 * SIN(   9380.959672717 *T + 3.223844306 )   +
     & 0.000135 * SIN(   6205.325306007 *T + 1.638054048 )   +
     & 0.000101 * SIN(   2699.734819318 *T + 5.481603249 )   +
     & 0.000104 * SIN(   -568.821874027 *T + 2.205734493 )   +
     & 0.000103 * SIN(   6321.103522627 *T + 2.440421099 )   +
     & 0.000119 * SIN(   6321.208885629 *T + 2.547496264 )   +
     & 0.000138 * SIN(   1975.492545856 *T + 2.314608466 )   +
     & 0.000121 * SIN(    137.033024162 *T + 4.539108237 )   +
     & 0.000123 * SIN(  19402.796952817 *T + 4.538074405 )   +
     & 0.000119 * SIN(  22805.735565994 *T + 2.869040566 )   +
     & 0.000133 * SIN(  64471.991241142 *T + 6.056405489 )   +
     & 0.000129 * SIN(    -85.827298831 *T + 2.540635083 )   +
     & 0.000131 * SIN(  13613.804277336 *T + 4.005732868 )   
      t24= 0.000104 * SIN(   9814.604100291 *T + 1.959967212 )   +
     & 0.000112 * SIN(  16097.679950283 *T + 3.589026260 )   +
     & 0.000123 * SIN(   2107.034507542 *T + 1.728627253 )   +
     & 0.000121 * SIN(  36949.230808424 *T + 6.072332087 )   +
     & 0.000108 * SIN( -12539.853380183 *T + 3.716133846 )   +
     & 0.000113 * SIN(  -7875.671863624 *T + 2.725771122 )   +
     & 0.000109 * SIN(   4171.425536614 *T + 4.033338079 )   +
     & 0.000101 * SIN(   6247.911759770 *T + 3.441347021 )   +
     & 0.000113 * SIN(   7330.728427345 *T + 0.656372122 )   +
     & 0.000113 * SIN(  51092.726050855 *T + 2.791483066 )   +
     & 0.000106 * SIN(   5621.842923210 *T + 1.815323326 )   +
     & 0.000101 * SIN(    111.430161497 *T + 5.711033677 )   +
     & 0.000103 * SIN(    909.818733055 *T + 2.812745443 )   +
     & 0.000101 * SIN(   1790.642637886 *T + 1.965746028 )   +
c T**1
     & T* 102.156724 * SIN(   6283.075849991 *T + 4.249032005 ) +
     & T* 1.706807 * SIN(  12566.151699983 *T + 4.205904248 )   +
     & T* 0.269668 * SIN(    213.299095438 *T + 3.400290479 )   +
     & T* 0.265919 * SIN(    529.690965095 *T + 5.836047367 )   +
     & T* 0.210568 * SIN(     -3.523118349 *T + 6.262738348 )   +
     & T* 0.077996 * SIN(   5223.693919802 *T + 4.670344204 )   
      t25= T* 0.054764 * SIN(   1577.343542448 *T + 4.534800170 )   +
     & T* 0.059146 * SIN(     26.298319800 *T + 1.083044735 )   +
     & T* 0.034420 * SIN(   -398.149003408 *T + 5.980077351 )   +
     & T* 0.032088 * SIN(  18849.227549974 *T + 4.162913471 )   +
     & T* 0.033595 * SIN(   5507.553238667 *T + 5.980162321 )   +
     & T* 0.029198 * SIN(   5856.477659115 *T + 0.623811863 )   +
     & T* 0.027764 * SIN(    155.420399434 *T + 3.745318113 )   +
     & T* 0.025190 * SIN(   5746.271337896 *T + 2.980330535 )   +
     & T* 0.022997 * SIN(   -796.298006816 *T + 1.174411803 )   +
     & T* 0.024976 * SIN(   5760.498431898 *T + 2.467913690 )   +
     & T* 0.021774 * SIN(    206.185548437 *T + 3.854787540 )   +
     & T* 0.017925 * SIN(   -775.522611324 *T + 1.092065955 )   +
     & T* 0.013794 * SIN(    426.598190876 *T + 2.699831988 )   +
     & T* 0.013276 * SIN(   6062.663207553 *T + 5.845801920 )   +
     & T* 0.011774 * SIN(  12036.460734888 *T + 2.292832062 )   +
     & T* 0.012869 * SIN(   6076.890301554 *T + 5.333425680 )   +
     & T* 0.012152 * SIN(   1059.381930189 *T + 6.222874454 )   +
     & T* 0.011081 * SIN(     -7.113547001 *T + 5.154724984 )   +
     & T* 0.010143 * SIN(   4694.002954708 *T + 4.044013795 )   +
     & T* 0.009357 * SIN(   5486.777843175 *T + 3.416081409 )   
      t26= T* 0.010084 * SIN(    522.577418094 *T + 0.749320262 )   +
     & T* 0.008587 * SIN(  10977.078804699 *T + 2.777152598 )   +
     & T* 0.008628 * SIN(   6275.962302991 *T + 4.562060226 )   +
     & T* 0.008158 * SIN(   -220.412642439 *T + 5.806891533 )   +
     & T* 0.007746 * SIN(   2544.314419883 *T + 1.603197066 )   +
     & T* 0.007670 * SIN(   2146.165416475 *T + 3.000200440 )   +
     & T* 0.007098 * SIN(     74.781598567 *T + 0.443725817 )   +
     & T* 0.006180 * SIN(   -536.804512095 *T + 1.302642751 )   +
     & T* 0.005818 * SIN(   5088.628839767 *T + 4.827723531 )   +
     & T* 0.004945 * SIN(  -6286.598968340 *T + 0.268305170 )   +
     & T* 0.004774 * SIN(   1349.867409659 *T + 5.808636673 )   +
     & T* 0.004687 * SIN(   -242.728603974 *T + 5.154890570 )   +
     & T* 0.006089 * SIN(   1748.016413067 *T + 4.403765209 )   +
     & T* 0.005975 * SIN(  -1194.447010225 *T + 2.583472591 )   +
     & T* 0.004229 * SIN(    951.718406251 *T + 0.931172179 )   +
     & T* 0.005264 * SIN(    553.569402842 *T + 2.336107252 )   +
     & T* 0.003049 * SIN(   5643.178563677 *T + 1.362634430 )   +
     & T* 0.002974 * SIN(   6812.766815086 *T + 1.583012668 )   +
     & T* 0.003403 * SIN(  -2352.866153772 *T + 2.552189886 )   +
     & T* 0.003030 * SIN(    419.484643875 *T + 5.286473844 )   
      t27= T* 0.003210 * SIN(     -7.046236698 *T + 1.863796539 )   +
     & T* 0.003058 * SIN(   9437.762934887 *T + 4.226420633 )   +
     & T* 0.002589 * SIN(  12352.852604545 *T + 1.991935820 )   +
     & T* 0.002927 * SIN(   5216.580372801 *T + 2.319951253 )   +
     & T* 0.002425 * SIN(   5230.807466803 *T + 3.084752833 )   +
     & T* 0.002656 * SIN(   3154.687084896 *T + 2.487447866 )   +
     & T* 0.002445 * SIN(  10447.387839604 *T + 2.347139160 )   +
     & T* 0.002990 * SIN(   4690.479836359 *T + 6.235872050 )   +
     & T* 0.002890 * SIN(   5863.591206116 *T + 0.095197563 )   +
     & T* 0.002498 * SIN(   6438.496249426 *T + 2.994779800 )   +
     & T* 0.001889 * SIN(   8031.092263058 *T + 3.569003717 )   +
     & T* 0.002567 * SIN(    801.820931124 *T + 3.425611498 )   +
     & T* 0.001803 * SIN( -71430.695617928 *T + 2.192295512 )   +
     & T* 0.001782 * SIN(      3.932153263 *T + 5.180433689 )   +
     & T* 0.001694 * SIN(  -4705.732307544 *T + 4.641779174 )   +
     & T* 0.001704 * SIN(  -1592.596013633 *T + 3.997097652 )   +
     & T* 0.001735 * SIN(   5849.364112115 *T + 0.417558428 )   +
     & T* 0.001643 * SIN(   8429.241266467 *T + 2.180619584 )   +
     & T* 0.001680 * SIN(     38.133035638 *T + 4.164529426 )   +
     & T* 0.002045 * SIN(   7084.896781115 *T + 0.526323854 )   
      t28= T* 0.001458 * SIN(   4292.330832950 *T + 1.356098141 )   +
     & T* 0.001437 * SIN(     20.355319399 *T + 3.895439360 )   +
     & T* 0.001738 * SIN(   6279.552731642 *T + 0.087484036 )   +
     & T* 0.001367 * SIN(  14143.495242431 *T + 3.987576591 )   +
     & T* 0.001344 * SIN(   7234.794256242 *T + 0.090454338 )   +
     & T* 0.001438 * SIN(  11499.656222793 *T + 0.974387904 )   +
     & T* 0.001257 * SIN(   6836.645252834 *T + 1.509069366 )   +
     & T* 0.001358 * SIN(  11513.883316794 *T + 0.495572260 )   +
     & T* 0.001628 * SIN(   7632.943259650 *T + 4.968445721 )   +
     & T* 0.001169 * SIN(    103.092774219 *T + 2.838496795 )   +
     & T* 0.001162 * SIN(   4164.311989613 *T + 3.408387778 )   +
     & T* 0.001092 * SIN(   6069.776754553 *T + 3.617942651 )   +
     & T* 0.001008 * SIN(  17789.845619785 *T + 0.286350174 )   +
     & T* 0.001008 * SIN(    639.897286314 *T + 1.610762073 )   +
     & T* 0.000918 * SIN(  10213.285546211 *T + 5.532798067 )   +
     & T* 0.001011 * SIN(  -6256.777530192 *T + 0.661826484 )   +
     & T* 0.000753 * SIN(  16730.463689596 *T + 3.905030235 )   +
     & T* 0.000737 * SIN(  11926.254413669 *T + 4.641956361 )   +
     & T* 0.000694 * SIN(   3340.612426700 *T + 2.111120332 )   +
     & T* 0.000701 * SIN(   3894.181829542 *T + 2.760823491 )   
      t29= T* 0.000689 * SIN(   -135.065080035 *T + 4.768800780 )   +
     & T* 0.000700 * SIN(  13367.972631107 *T + 5.760439898 )   +
     & T* 0.000664 * SIN(   6040.347246017 *T + 1.051215840 )   +
     & T* 0.000654 * SIN(   5650.292110678 *T + 4.911332503 )   +
     & T* 0.000788 * SIN(   6681.224853400 *T + 4.699648011 )   +
     & T* 0.000628 * SIN(   5333.900241022 *T + 5.024608847 )   +
     & T* 0.000755 * SIN(   -110.206321219 *T + 4.370971253 )   +
     & T* 0.000628 * SIN(   6290.189396992 *T + 3.660478857 )   +
     & T* 0.000635 * SIN(  25132.303399966 *T + 4.121051532 )   +
     & T* 0.000534 * SIN(   5966.683980335 *T + 1.173284524 )   +
     & T* 0.000543 * SIN(   -433.711737877 *T + 0.345585464 )   +
     & T* 0.000517 * SIN(  -1990.745017041 *T + 5.414571768 )   +
     & T* 0.000504 * SIN(   5767.611978898 *T + 2.328281115 )   +
     & T* 0.000485 * SIN(   5753.384884897 *T + 1.685874771 )   +
     & T* 0.000463 * SIN(   7860.419392439 *T + 5.297703006 )   +
     & T* 0.000604 * SIN(    515.463871093 *T + 0.591998446 )   +
     & T* 0.000443 * SIN(  12168.002696575 *T + 4.830881244 )   +
     & T* 0.000570 * SIN(    199.072001436 *T + 3.899190272 )   +
     & T* 0.000465 * SIN(  10969.965257698 *T + 0.476681802 )   +
     & T* 0.000424 * SIN(  -7079.373856808 *T + 1.112242763 )   
      t30= T* 0.000427 * SIN(    735.876513532 *T + 1.994214480 )   +
     & T* 0.000478 * SIN(  -6127.655450557 *T + 3.778025483 )   +
     & T* 0.000414 * SIN(  10973.555686350 *T + 5.441088327 )   +
     & T* 0.000512 * SIN(   1589.072895284 *T + 0.107123853 )   +
     & T* 0.000378 * SIN(  10984.192351700 *T + 0.915087231 )   +
     & T* 0.000402 * SIN(  11371.704689758 *T + 4.107281715 )   +
     & T* 0.000453 * SIN(   9917.696874510 *T + 1.917490952 )   +
     & T* 0.000395 * SIN(    149.563197135 *T + 2.763124165 )   +
     & T* 0.000371 * SIN(   5739.157790895 *T + 3.112111866 )   +
     & T* 0.000350 * SIN(  11790.629088659 *T + 0.440639857 )   +
     & T* 0.000356 * SIN(   6133.512652857 *T + 5.444568842 )   +
     & T* 0.000344 * SIN(    412.371096874 *T + 5.676832684 )   +
     & T* 0.000383 * SIN(    955.599741609 *T + 5.559734846 )   +
     & T* 0.000333 * SIN(   6496.374945429 *T + 0.261537984 )   +
     & T* 0.000340 * SIN(   6055.549660552 *T + 5.975534987 )   +
     & T* 0.000334 * SIN(   1066.495477190 *T + 2.335063907 )   +
     & T* 0.000399 * SIN(  11506.769769794 *T + 5.321230910 )   +
     & T* 0.000314 * SIN(  18319.536584880 *T + 2.313312404 )   +
     & T* 0.000424 * SIN(   1052.268383188 *T + 1.211961766 )   +
     & T* 0.000307 * SIN(     63.735898303 *T + 3.169551388 )   
      t31= T* 0.000329 * SIN(     29.821438149 *T + 6.106912080 )   +
     & T* 0.000357 * SIN(   6309.374169791 *T + 4.223760346 )   +
     & T* 0.000312 * SIN(  -3738.761430108 *T + 2.180556645 )   +
     & T* 0.000301 * SIN(    309.278322656 *T + 1.499984572 )   +
     & T* 0.000268 * SIN(  12043.574281889 *T + 2.447520648 )   +
     & T* 0.000257 * SIN(  12491.370101415 *T + 3.662331761 )   +
     & T* 0.000290 * SIN(    625.670192312 *T + 1.272834584 )   +
     & T* 0.000256 * SIN(   5429.879468239 *T + 1.913426912 )   +
     & T* 0.000339 * SIN(   3496.032826134 *T + 4.165930011 )   +
     & T* 0.000283 * SIN(   3930.209696220 *T + 4.325565754 )   +
     & T* 0.000241 * SIN(  12528.018664345 *T + 3.832324536 )   +
     & T* 0.000304 * SIN(   4686.889407707 *T + 1.612348468 )   +
     & T* 0.000259 * SIN(  16200.772724501 *T + 3.470173146 )   +
     & T* 0.000238 * SIN(  12139.553509107 *T + 1.147977842 )   +
     & T* 0.000236 * SIN(   6172.869528772 *T + 3.776271728 )   +
     & T* 0.000296 * SIN(  -7058.598461315 *T + 0.460368852 )   +
     & T* 0.000306 * SIN(  10575.406682942 *T + 0.554749016 )   +
     & T* 0.000251 * SIN(  17298.182327326 *T + 0.834332510 )   +
     & T* 0.000290 * SIN(   4732.030627343 *T + 4.759564091 )   +
     & T* 0.000261 * SIN(   5884.926846583 *T + 0.298259862 )   
      t32= T* 0.000249 * SIN(   5547.199336460 *T + 3.749366406 )   +
     & T* 0.000213 * SIN(  11712.955318231 *T + 5.415666119 )   +
     & T* 0.000223 * SIN(   4701.116501708 *T + 2.703203558 )   +
     & T* 0.000268 * SIN(   -640.877607382 *T + 0.283670793 )   +
     & T* 0.000209 * SIN(   5636.065016677 *T + 1.238477199 )   +
     & T* 0.000193 * SIN(  10177.257679534 *T + 1.943251340 )   +
     & T* 0.000182 * SIN(   6283.143160294 *T + 2.456157599 )   +
     & T* 0.000184 * SIN(   -227.526189440 *T + 5.888038582 )   +
     & T* 0.000182 * SIN(  -6283.008539689 *T + 0.241332086 )   +
     & T* 0.000228 * SIN(  -6284.056171060 *T + 2.657323816 )   +
     & T* 0.000166 * SIN(   7238.675591600 *T + 5.930629110 )   +
     & T* 0.000167 * SIN(   3097.883822726 *T + 5.570955333 )   +
     & T* 0.000159 * SIN(   -323.505416657 *T + 5.786670700 )   +
     & T* 0.000154 * SIN(  -4136.910433516 *T + 1.517805532 )   +
     & T* 0.000176 * SIN(  12029.347187887 *T + 3.139266834 )   +
     & T* 0.000167 * SIN(  12132.439962106 *T + 3.556352289 )   +
     & T* 0.000153 * SIN(    202.253395174 *T + 1.463313961 )   +
     & T* 0.000157 * SIN(  17267.268201691 *T + 1.586837396 )   +
     & T* 0.000142 * SIN(  83996.847317911 *T + 0.022670115 )   +
     & T* 0.000152 * SIN(  17260.154654690 *T + 0.708528947 )   
      t33= T* 0.000144 * SIN(   6084.003848555 *T + 5.187075177 )   + 
     & T* 0.000135 * SIN(   5756.566278634 *T + 1.993229262 )   + 
     & T* 0.000134 * SIN(   5750.203491159 *T + 3.457197134 )   +
     & T* 0.000144 * SIN(   5326.786694021 *T + 6.066193291 )   +
     & T* 0.000160 * SIN(  11015.106477335 *T + 1.710431974 )   +
     & T* 0.000133 * SIN(   3634.621024518 *T + 2.836451652 )   +
     & T* 0.000134 * SIN(  18073.704938650 *T + 5.453106665 )   +
     & T* 0.000134 * SIN(   1162.474704408 *T + 5.326898811 )   +
     & T* 0.000128 * SIN(   5642.198242609 *T + 2.511652591 )   +
     & T* 0.000160 * SIN(    632.783739313 *T + 5.628785365 )   +
     & T* 0.000132 * SIN(  13916.019109642 *T + 0.819294053 )   +
     & T* 0.000122 * SIN(  14314.168113050 *T + 5.677408071 )   +
     & T* 0.000125 * SIN(  12359.966151546 *T + 5.251984735 )   +
     & T* 0.000121 * SIN(   5749.452731634 *T + 2.210924603 )   +
     & T* 0.000136 * SIN(   -245.831646229 *T + 1.646502367 )   +
     & T* 0.000120 * SIN(   5757.317038160 *T + 3.240883049 )   +
     & T* 0.000134 * SIN(  12146.667056108 *T + 3.059480037 )   +
     & T* 0.000137 * SIN(   6206.809778716 *T + 1.867105418 )   +
     & T* 0.000141 * SIN(  17253.041107690 *T + 2.069217456 )   +
     & T* 0.000129 * SIN(  -7477.522860216 *T + 2.781469314 )   
      t34= T* 0.000116 * SIN(   5540.085789459 *T + 4.281176991 )   +
     & T* 0.000116 * SIN(   9779.108676125 *T + 3.320925381 )   +
     & T* 0.000129 * SIN(   5237.921013804 *T + 3.497704076 )   +
     & T* 0.000113 * SIN(   5959.570433334 *T + 0.983210840 )   +
     & T* 0.000122 * SIN(   6282.095528923 *T + 2.674938860 )   +
     & T* 0.000140 * SIN(    -11.045700264 *T + 4.957936982 )   +
     & T* 0.000108 * SIN(  23543.230504682 *T + 1.390113589 )   +
     & T* 0.000106 * SIN( -12569.674818332 *T + 0.429631317 )   +
     & T* 0.000110 * SIN(   -266.607041722 *T + 5.501340197 )   +
     & T* 0.000115 * SIN(  12559.038152982 *T + 4.691456618 )   +
     & T* 0.000134 * SIN(  -2388.894020449 *T + 0.577313584 )   +
     & T* 0.000109 * SIN(  10440.274292604 *T + 6.218148717 )   +
     & T* 0.000102 * SIN(   -543.918059096 *T + 1.477842615 )   +
     & T* 0.000108 * SIN(  21228.392023546 *T + 2.237753948 )   +
     & T* 0.000101 * SIN(  -4535.059436924 *T + 3.100492232 )   +
     & T* 0.000103 * SIN(     76.266071276 *T + 5.594294322 )   +
     & T* 0.000104 * SIN(    949.175608970 *T + 5.674287810 )   +
     & T* 0.000101 * SIN(  13517.870106233 *T + 2.196632348 )   +
     & T* 0.000100 * SIN(  11933.367960670 *T + 4.056084160 )   +
c T**2
     & TT* 4.322990 * SIN(   6283.075849991 *T + 2.642893748 )   
      t35= TT* 0.406495 * SIN(      0.000000000 *T + 4.712388980 )   +
     & TT* 0.122605 * SIN(  12566.151699983 *T + 2.438140634 )   +
     & TT* 0.019476 * SIN(    213.299095438 *T + 1.642186981 )   +
     & TT* 0.016916 * SIN(    529.690965095 *T + 4.510959344 )   +
     & TT* 0.013374 * SIN(     -3.523118349 *T + 1.502210314 )   +
     & TT* 0.008042 * SIN(     26.298319800 *T + 0.478549024 )   +
     & TT* 0.007824 * SIN(    155.420399434 *T + 5.254710405 )   +
     & TT* 0.004894 * SIN(   5746.271337896 *T + 4.683210850 )   +
     & TT* 0.004875 * SIN(   5760.498431898 *T + 0.759507698 )   +
     & TT* 0.004416 * SIN(   5223.693919802 *T + 6.028853166 )   +
     & TT* 0.004088 * SIN(     -7.113547001 *T + 0.060926389 )   +
     & TT* 0.004433 * SIN(  77713.771467920 *T + 3.627734103 )   +
     & TT* 0.003277 * SIN(  18849.227549974 *T + 2.327912542 )   +
     & TT* 0.002703 * SIN(   6062.663207553 *T + 1.271941729 )   +
     & TT* 0.003435 * SIN(   -775.522611324 *T + 0.747446224 )   +
     & TT* 0.002618 * SIN(   6076.890301554 *T + 3.633715689 )   +
     & TT* 0.003146 * SIN(    206.185548437 *T + 5.647874613 )   +
     & TT* 0.002544 * SIN(   1577.343542448 *T + 6.232904270 )   +
     & TT* 0.002218 * SIN(   -220.412642439 *T + 1.309509946 )   +
     & TT* 0.002197 * SIN(   5856.477659115 *T + 2.407212349 )   
      t36= TT* 0.002897 * SIN(   5753.384884897 *T + 5.863842246 )   +
     & TT* 0.001766 * SIN(    426.598190876 *T + 0.754113147 )   +
     & TT* 0.001738 * SIN(   -796.298006816 *T + 2.714942671 )   +
     & TT* 0.001695 * SIN(    522.577418094 *T + 2.629369842 )   +
     & TT* 0.001584 * SIN(   5507.553238667 *T + 1.341138229 )   +
     & TT* 0.001503 * SIN(   -242.728603974 *T + 0.377699736 )   +
     & TT* 0.001552 * SIN(   -536.804512095 *T + 2.904684667 )   +
     & TT* 0.001370 * SIN(   -398.149003408 *T + 1.265599125 )   +
     & TT* 0.001889 * SIN(  -5573.142801634 *T + 4.413514859 )   +
     & TT* 0.001722 * SIN(   6069.776754553 *T + 2.445966339 )   +
     & TT* 0.001124 * SIN(   1059.381930189 *T + 5.041799657 )   +
     & TT* 0.001258 * SIN(    553.569402842 *T + 3.849557278 )   +
     & TT* 0.000831 * SIN(    951.718406251 *T + 2.471094709 )   +
     & TT* 0.000767 * SIN(   4694.002954708 *T + 5.363125422 )   +
     & TT* 0.000756 * SIN(   1349.867409659 *T + 1.046195744 )   +
     & TT* 0.000775 * SIN(    -11.045700264 *T + 0.245548001 )   +
     & TT* 0.000597 * SIN(   2146.165416475 *T + 4.543268798 )   +
     & TT* 0.000568 * SIN(   5216.580372801 *T + 4.178853144 )   +
     & TT* 0.000711 * SIN(   1748.016413067 *T + 5.934271972 )   +
     & TT* 0.000499 * SIN(  12036.460734888 *T + 0.624434410 )   
      t37= TT* 0.000671 * SIN(  -1194.447010225 *T + 4.136047594 )   +
     & TT* 0.000488 * SIN(   5849.364112115 *T + 2.209679987 )   +
     & TT* 0.000621 * SIN(   6438.496249426 *T + 4.518860804 )   +
     & TT* 0.000495 * SIN(  -6286.598968340 *T + 1.868201275 )   +
     & TT* 0.000456 * SIN(   5230.807466803 *T + 1.271231591 )   +
     & TT* 0.000451 * SIN(   5088.628839767 *T + 0.084060889 )   +
     & TT* 0.000435 * SIN(   5643.178563677 *T + 3.324456609 )   +
     & TT* 0.000387 * SIN(  10977.078804699 *T + 4.052488477 )   +
     & TT* 0.000547 * SIN( 161000.685737473 *T + 2.841633844 )   +
     & TT* 0.000522 * SIN(   3154.687084896 *T + 2.171979966 )   +
     & TT* 0.000375 * SIN(   5486.777843175 *T + 4.983027306 )   +
     & TT* 0.000421 * SIN(   5863.591206116 *T + 4.546432249 )   +
     & TT* 0.000439 * SIN(   7084.896781115 *T + 0.522967921 )   +
     & TT* 0.000309 * SIN(   2544.314419883 *T + 3.172606705 )   +
     & TT* 0.000347 * SIN(   4690.479836359 *T + 1.479586566 )   +
     & TT* 0.000317 * SIN(    801.820931124 *T + 3.553088096 )   +
     & TT* 0.000262 * SIN(    419.484643875 *T + 0.606635550 )   +
     & TT* 0.000248 * SIN(   6836.645252834 *T + 3.014082064 )   +
     & TT* 0.000245 * SIN(  -1592.596013633 *T + 5.519526220 )   +
     & TT* 0.000225 * SIN(   4292.330832950 *T + 2.877956536 )   
      t38= TT* 0.000214 * SIN(   7234.794256242 *T + 1.605227587 )   +
     & TT* 0.000205 * SIN(   5767.611978898 *T + 0.625804796 )   +
     & TT* 0.000180 * SIN(  10447.387839604 *T + 3.499954526 )   +
     & TT* 0.000229 * SIN(    199.072001436 *T + 5.632304604 )   +
     & TT* 0.000214 * SIN(    639.897286314 *T + 5.960227667 )   +
     & TT* 0.000175 * SIN(   -433.711737877 *T + 2.162417992 )   +
     & TT* 0.000209 * SIN(    515.463871093 *T + 2.322150893 )   +
     & TT* 0.000173 * SIN(   6040.347246017 *T + 2.556183691 )   +
     & TT* 0.000184 * SIN(   6309.374169791 *T + 4.732296790 )   +
     & TT* 0.000227 * SIN( 149854.400134205 *T + 5.385812217 )   +
     & TT* 0.000154 * SIN(   8031.092263058 *T + 5.120720920 )   +
     & TT* 0.000151 * SIN(   5739.157790895 *T + 4.815000443 )   +
     & TT* 0.000197 * SIN(   7632.943259650 *T + 0.222827271 )   +
     & TT* 0.000197 * SIN(     74.781598567 *T + 3.910456770 )   +
     & TT* 0.000138 * SIN(   6055.549660552 *T + 1.397484253 )   +
     & TT* 0.000149 * SIN(  -6127.655450557 *T + 5.333727496 )   +
     & TT* 0.000137 * SIN(   3894.181829542 *T + 4.281749907 )   +
     & TT* 0.000135 * SIN(   9437.762934887 *T + 5.979971885 )   +
     & TT* 0.000139 * SIN(  -2352.866153772 *T + 4.715630782 )   +
     & TT* 0.000142 * SIN(   6812.766815086 *T + 0.513330157 )   
      t39= TT* 0.000120 * SIN(  -4705.732307544 *T + 0.194160689 )   +
     & TT* 0.000131 * SIN( -71430.695617928 *T + 0.000379226 )   +
     & TT* 0.000124 * SIN(   6279.552731642 *T + 2.122264908 )   +
     & TT* 0.000108 * SIN(  -6256.777530192 *T + 0.883445696 )   +
c T**3
     & TTT* 0.143388 * SIN(   6283.075849991 *T + 1.131453581 )   +
     & TTT* 0.006671 * SIN(  12566.151699983 *T + 0.775148887 )   +
     & TTT* 0.001480 * SIN(    155.420399434 *T + 0.480016880 )   +
     & TTT* 0.000934 * SIN(    213.299095438 *T + 6.144453084 )   +
     & TTT* 0.000795 * SIN(    529.690965095 *T + 2.941595619 )   +
     & TTT* 0.000673 * SIN(   5746.271337896 *T + 0.120415406 )   +
     & TTT* 0.000672 * SIN(   5760.498431898 *T + 5.317009738 )   +
     & TTT* 0.000389 * SIN(   -220.412642439 *T + 3.090323467 )   +
     & TTT* 0.000373 * SIN(   6062.663207553 *T + 3.003551964 )   +
     & TTT* 0.000360 * SIN(   6076.890301554 *T + 1.918913041 )   +
     & TTT* 0.000316 * SIN(    -21.340641002 *T + 5.545798121 )   +
     & TTT* 0.000315 * SIN(   -242.728603974 *T + 1.884932563 )   +
     & TTT* 0.000278 * SIN(    206.185548437 *T + 1.266254859 )   +
     & TTT* 0.000238 * SIN(   -536.804512095 *T + 4.532664830 )   +
     & TTT* 0.000185 * SIN(    522.577418094 *T + 4.578313856 )   +
     & TTT* 0.000245 * SIN(  18849.227549974 *T + 0.587467082 )   
      t40= TTT* 0.000180 * SIN(    426.598190876 *T + 5.151178553 )   +
     & TTT* 0.000200 * SIN(    553.569402842 *T + 5.355983739 )   +
     & TTT* 0.000141 * SIN(   5223.693919802 *T + 1.336556009 )   +
     & TTT* 0.000104 * SIN(   5856.477659115 *T + 4.239842759 )   +
c T**4
     & TTTT* 0.003826 * SIN(   6283.075849991 *T + 5.705257275 )   +
     & TTTT* 0.000303 * SIN(  12566.151699983 *T + 5.407132842 )   +
     & TTTT* 0.000209 * SIN(    155.420399434 *T + 1.989815753 )   
      t41=0.00065*sin(6069.776754*T+4.021194)+
     &    0.00033*sin( 213.299095*T+5.543132)+
     &   -0.00196*sin(6208.294251*T+5.696701)+
     &   -0.00173*sin(  74.781599*T+2.435900)

      ctatv=t1+t2+t3+t4+t5+t6+t7+t8+t9+t10+t11+t12+t13+t14+t15
     ++t16+t17+t18+t19+t20+t21+t22+t23+t24+t25+t26+t27+t28+t29+t30
     ++t31+t32+t33+t34+t35+t36+t37+t38+t39+t40+t41
	ctatv=ctatv*1.d-6
	return
	end 
